!Object constantsFor: 'Geos Libraries'!

geosLIB4 'SYSTEM\foam'! !

!Object constantsFor: 'Geos vardata'!

attrComplexMonikerPlaceBitmapAtLeft 32768!
attrComplexMonikerSeparatorStartPoint 32772!
hintComplexMonikerDrawSeparator 32776!
hintComplexMonikerDontDrawSeparator 32780!
hintComplexMonikerCenterTextHorizontally 32784!
hintComplexMonikerMinimizeIconSpacing 32788!
tempComplexMonikerCurrentZoomLevel 32792!
attrUnderlinedVisTextNoUnderlines 18944!
hintEfsShortSearchMoniker 32768!
attrFfsDocumentDir 27136!
hintFlashingNoteDestroySelfAfterDismiss 27136!
attrFlashingNoteMinimumDuration 27140!
tempFlashingNoteTimerData 27144!
tempFlashingNoteDismissActionOk 27148!
tempFlashingNoteTriedDismiss 27152!
tempFlashingNoteAltMargins 27156!
tempFoamSubAppNotDefaultLaunchable 27136!
attrGenValueWithListDoNotAllowNavigation 27136!
attrGenValueWithListMaxTextLen 27140!
attrGreyFrameFlatFrameLook 27136!
attrListWithUserDefinedTextObjectSelected 27136!
attrTextWithListDoNotAllowNavigation 27136!
attrTltIsBackTrigger 34816!
attrAnalogClockShowAmPm 26624!
attrFilterListCustomIdentifiers 27648!
attrFoamFontControlShortListFontType 27648!
hintFoamProgressDialogDestroySelfAfterDismiss 27648!
attrFoamProgressDialogDontDismissOnCancel 27652!
hintLiDrawLevelsVertically 27648!
attrUnderlinedTextWithListDoNotAllowNavigation 27648!
tempFoamHelpControlUi 28160!
!

!Object constantsFor: 'Geos messages'!

animationStartAnimation 8192!
animationAdvanceAnimation 8193!
animationAnimationComplete 8194!
monikerReplaceMoniker 32768!
monikerGetMoniker 32769!
drawUnderline 18944!
moveToEndIfNotFocused 18945!
removeMe 24576!
clockTick 24577!
startTimer 24578!
stopTimer 24579!
launchSelectedApp 27136!
appSelected 27137!
getMultipleSelections 32768!
getAttrs 32769!
setAttrs 32770!
getNumSelections 32771!
getMultipleSelectionsBlock 32772!
resetSearch 32773!
getSelectionInfo 32774!
setPath 27136!
getPath 27137!
open 27138!
noteSetDuration 27136!
noteAcceptUserAction 27137!
noteDismissDialog 27138!
noteDismissDialogNow 27139!
returnToLauncher 27136!
setSingleSelectionOrUserDefined 27136!
needMoniker 27136!
toneSelected 27137!
closeInteraction 27138!
initDynamicList 27139!
getToneName 27140!
setToneName 27141!
setToDefault 27142!
setToNone 27143!
playSampling 27144!
setRingingTone 27145!
ringingToneStatus 27146!
playDelayedSampling 27147!
stopAnimation 27136!
startAnimation 27137!
changeMoniker 27138!
activateOtherLevel 34816!
listMapPhysicalToApp 27648!
listMapAppToPhysical 27649!
listSetSingleSelection 27650!
listSetMultipleSelections 27651!
listGetSelection 27652!
listGetMultipleSelections 27653!
listGetItemOptr 27654!
listSetItemState 27655!
listIsItemSelected 27656!
listMakeItemVisible 27657!
listReplaceItemMoniker 27658!
listReplaceItemMonikerOptr 27659!
listReplaceItemText 27660!
listGetFocusItem 27661!
listSetFocusItem 27662!
listInitialize 27663!
textSendFilterMsg 27648!
textReset 27649!
textResetTextIfNotFocused 27650!
setFont 27648!
setJustification 27648!
setPointSize 27648!
setPointSizeFromList 27649!
progressDialogSetDescriptionTextOptr 27648!
progressDialogSetStatusText 27649!
progressDialogSetCancelAction 27650!
progressDialogSetStatusTextOptr 27651!
progressDialogAppendStatusText 27652!
progressDialogSetDescriptionText 27653!
progressDialogAppendDescriptionText 27654!
progressDialogCancelTriggered 27655!
plainTextChange 27648!
styleChange 27649!
extendedStyleChange 27650!
setLeftIcon 27648!
setRightIcon 27649!
replaceTypeBitmap 27648!
setLevel 27649!
!

!Geos class methodsFor: 'library calls'!

FoamSetDocumentDir: fDocDir
	"void pascal FoamSetDocumentDir(FDocumentDir fDocDir) in foam.goh"
	^GEOS call: fDocDir with: #[4 0 41 1 0]!

FoamGetDocumentDir
	"FDocumentDir pascal FoamGetDocumentDir(void) in foam.goh"
	^GEOS call: #[4 0 42 1]!

FoamGetDocumentDirName: fDocDir with: buffer
	"void pascal FoamGetDocumentDirName(FDocumentDir fDocDir, FileLongName *buffer) in foam.goh"
	^GEOS call: fDocDir with: buffer with: #[4 0 43 1 3 0]!

FoamDisplayDeleteWarning: preText with: midText with: postText
	"InteractionCommand pascal FoamDisplayDeleteWarning(optr preText, TCHAR *midText, optr postText) in foam.goh"
	^GEOS call: preText with: midText with: postText with: #[4 0 44 2 3 2 1]!

FoamDisplayDeleteWarningNoBlock: bodyText with: msg with: dest
	"void pascal FoamDisplayDeleteWarningNoBlock(optr bodyText, word msg, optr dest) in foam.goh"
	^GEOS call: bodyText with: msg with: dest with: #[4 0 137 2 1 2 0]!

FoamDisplayWarning: warningText
	"void pascal FoamDisplayWarning(optr warningText) in foam.goh"
	^GEOS call: warningText with: #[4 0 45 2 0]!

FoamDisplayQuestion: questionText
	"InteractionCommand pascal FoamDisplayQuestion(optr questionText) in foam.goh"
	^GEOS call: questionText with: #[4 0 46 2 1]!

FoamDisplayError: errorText
	"void pascal FoamDisplayError(optr errorText) in foam.goh"
	^GEOS call: errorText with: #[4 0 47 2 0]!

FoamDisplayOkCancelWarning: warningText
	"InteractionCommand pascal FoamDisplayOkCancelWarning(optr warningText) in foam.goh"
	^GEOS call: warningText with: #[4 0 69 2 1]!

FoamDocSetAttrInfo: docHandle with: fileAttrInfo
	"void pascal FoamDocSetAttrInfo(DocumentHandle docHandle, FileAttrInfo *fileAttrInfo) in foam.goh"
	^GEOS call: docHandle with: fileAttrInfo with: #[4 0 48 1 3 0]!

FoamDocCheckProtocol: docHandle with: numCreatorChars with: majorProtocol with: minorProtocol
	"Boolean pascal FoamDocCheckProtocol(DocumentHandle docHandle, word numCreatorChars, word majorProtocol, word minorProtocol) in foam.goh"
	^GEOS call: docHandle with: numCreatorChars with: majorProtocol with: minorProtocol with: #[4 0 49 1 1 1 1 4]!

FoamDocCreate: docInfo with: fileAttr with: prefix
	"word pascal FoamDocCreate(DocumentInfo *docInfo, FileAttrInfo *fileAttr, DocumentPrefix *prefix) in foam.goh"
	^GEOS call: docInfo with: fileAttr with: prefix with: #[4 0 50 3 3 3 1]!

FoamDocOpen: docInfo with: docAccess
	"DocumentHandle pascal FoamDocOpen(DocumentInfo *docInfo, FDocAccess docAccess) in foam.goh"
	^GEOS call: docInfo with: docAccess with: #[4 0 51 3 1 1]!

FoamDocClose: docHandle
	"void pascal FoamDocClose(DocumentHandle docHandle) in foam.goh"
	^GEOS call: docHandle with: #[4 0 52 1 0]!

FoamDocDelete: docInfo
	"Boolean pascal FoamDocDelete(DocumentInfo *docInfo) in foam.goh"
	^GEOS call: docInfo with: #[4 0 53 3 4]!

FoamDocSetBlockHandle: docHandle with: block with: docHeader
	"void pascal FoamDocSetBlockHandle(DocumentHandle docHandle, VMBlockHandle block, FoamDocHeader docHeader) in foam.goh"
	^GEOS call: docHandle with: block with: docHeader with: #[4 0 54 1 1 1 0]!

FoamDocSetHeaderData: docHandle with: data with: docHeader
	"void pascal FoamDocSetHeaderData(DocumentHandle docHandle, word data, FoamDocHeader docHeader) in foam.goh"
	^GEOS call: docHandle with: data with: docHeader with: #[4 0 55 1 1 1 0]!

FoamDocGetHeaderData: docHandle with: docHeader
	"word pascal FoamDocGetHeaderData(DocumentHandle docHandle, FoamDocHeader docHeader) in foam.goh"
	^GEOS call: docHandle with: docHeader with: #[4 0 56 1 1 1]!

FoamDocSetTextLength: docHandle with: length
	"void pascal FoamDocSetTextLength(DocumentHandle docHandle, dword length) in foam.goh"
	^GEOS call: docHandle with: length with: #[4 0 57 1 2 0]!

FoamDocGetTextLength: docHandle
	"dword pascal FoamDocGetTextLength(DocumentHandle docHandle) in foam.goh"
	^GEOS call: docHandle with: #[4 0 58 1 2]!

FoamDocGetTextLengthFromField: field
	"dword pascal FoamDocGetTextLengthFromField(char *field) in foam.goh"
	^GEOS call: field with: #[4 0 59 3 2]!

FoamDocGetDosTextSmall: docHandle with: buffer with: count
	"word pascal FoamDocGetDosTextSmall(DocumentHandle docHandle, void *buffer, word count) in foam.goh"
	^GEOS call: docHandle with: buffer with: count with: #[4 0 60 1 3 1 1]!

FoamDocStoreDosTextSmall: docHandle with: buffer with: bufferLen
	"void pascal FoamDocStoreDosTextSmall(DocumentHandle docHandle, void *buffer, word bufferLen) in foam.goh"
	^GEOS call: docHandle with: buffer with: bufferLen with: #[4 0 61 1 3 1 0]!

FoamDocConvertFromDosInit
	"optr pascal FoamDocConvertFromDosInit(void) in foam.goh"
	^GEOS call: #[4 0 63 2]!

FoamDocConvertFromDosAppend: object with: buffer with: bufferLength
	"void pascal FoamDocConvertFromDosAppend(optr object, TCHAR *buffer, word bufferLength) in foam.goh"
	^GEOS call: object with: buffer with: bufferLength with: #[4 0 64 2 3 1 0]!

FoamDocConvertFromDosDone: docHandle with: object
	"void pascal FoamDocConvertFromDosDone(DocumentHandle docHandle, optr object) in foam.goh"
	^GEOS call: docHandle with: object with: #[4 0 65 1 2 0]!

FoamDocConvertToDosInit: docHandle
	"optr pascal FoamDocConvertToDosInit(DocumentHandle docHandle) in foam.goh"
	^GEOS call: docHandle with: #[4 0 66 1 2]!

FoamDocConvertToDosRange: object with: buffer with: startPos with: endPos
	"word pascal FoamDocConvertToDosRange(optr object, TCHAR *buffer, dword startPos, dword endPos) in foam.goh"
	^GEOS call: object with: buffer with: startPos with: endPos with: #[4 0 67 2 3 2 2 1]!

FoamDocConvertToDosDone: object
	"void pascal FoamDocConvertToDosDone(optr object) in foam.goh"
	^GEOS call: object with: #[4 0 68 2 0]!

FoamDocIsTextFormatted: docHandle with: fontInfo
	"Boolean pascal FoamDocIsTextFormatted(DocumentHandle docHandle, DocumentFontInfo *fontInfo) in foam.goh"
	^GEOS call: docHandle with: fontInfo with: #[4 0 62 1 3 4]!

FoamCheckIfOutOfSpace
	"FoamDiskSpaceStatus pascal FoamCheckIfOutOfSpace(void) in foam.goh"
	^GEOS call: #[4 0 70 1]!

FoamWarnIfOutOfSpace
	"Boolean pascal FoamWarnIfOutOfSpace(void) in foam.goh"
	^GEOS call: #[4 0 71 4]!

FoamWarnForSaving: space
	"FoamSaveAction pascal FoamWarnForSaving(dword space) in foam.goh"
	^GEOS call: space with: #[4 0 72 2 1]!

FoamCancelIfNoFreeSpace
	"Boolean pascal FoamCancelIfNoFreeSpace(void) in foam.goh"
	^GEOS call: #[4 0 73 4]!

FoamWarnIfNotEnoughSpace: space
	"FoamDiskSpaceStatus pascal FoamWarnIfNotEnoughSpace(dword space) in foam.goh"
	^GEOS call: space with: #[4 0 135 2 1]!

FoamWarnSpaceAfterOperation
	"FoamDiskSpaceStatus pascal FoamWarnSpaceAfterOperation(void) in foam.goh"
	^GEOS call: #[4 0 138 1]!

FoamGetFreeDiskSpace
	"dword pascal FoamGetFreeDiskSpace(void) in foam.goh"
	^GEOS call: #[4 0 74 2]!

FoamRoundUpAsMultipleOfClusterSize: space
	"dword pascal FoamRoundUpAsMultipleOfClusterSize(dword space) in foam.goh"
	^GEOS call: space with: #[4 0 142 2 2]!

FoamRoundUpAsMultipleOfClusterSizeOnDisk: space with: diskHan
	"dword pascal FoamRoundUpAsMultipleOfClusterSizeOnDisk(dword space, DiskHandle diskHan) in foam.goh"
	^GEOS call: space with: diskHan with: #[4 0 231 2 1 2]!

FoamLaunchApplication: applicationConstant
	"void pascal FoamLaunchApplication(FApplication applicationConstant) in foam.goh"
	^GEOS call: applicationConstant with: #[4 0 75 1 0]!

PutUpDialogViaUIThread: dialogBoxTemplate
	"optr pascal PutUpDialogViaUIThread(optr dialogBoxTemplate) in foam.goh"
	^GEOS call: dialogBoxTemplate with: #[4 0 85 2 2]!

TakeDownDialogViaUIThread: dialogBox
	"void pascal TakeDownDialogViaUIThread(optr dialogBox) in foam.goh"
	^GEOS call: dialogBox with: #[4 0 86 2 0]!

FoamStandardDialogOptr: helpFile with: helpContext with: layerPriority with: rejectTriggerMessage with: rejectTriggerDestination with: acceptTriggerMessage with: acceptTriggerDestination with: triggerTopText with: arg2 with: arg1 with: dialogFlags with: bodyText with: titleText with: titleIconBitmap
	"InteractionCommand pascal FoamStandardDialogOptr(void *helpFile, void *helpContext, LayerPriority layerPriority, Message rejectTriggerMessage, optr rejectTriggerDestination, Message acceptTriggerMessage, optr acceptTriggerDestination, optr triggerTopText, TCHAR *arg2, TCHAR *arg1, FoamCustomDialogBoxFlags dialogFlags, optr bodyText, optr titleText, optr titleIconBitmap) in foam.goh"
	^GEOS call: helpFile with: helpContext with: layerPriority with: rejectTriggerMessage with: rejectTriggerDestination with: acceptTriggerMessage with: acceptTriggerDestination with: triggerTopText with: arg2 with: arg1 with: dialogFlags with: bodyText with: titleText with: titleIconBitmap with: #[4 0 76 3 3 1 1 2 1 2 2 3 3 1 2 2 2 1]!

FoamStandardDialogOptrNoBlock: helpFile with: helpContext with: layerPriority with: rejectTriggerMessage with: rejectTriggerDestination with: acceptTriggerMessage with: acceptTriggerDestination with: triggerTopText with: arg2 with: arg1 with: dialogFlags with: bodyText with: titleText with: titleIconBitmap
	"optr pascal FoamStandardDialogOptrNoBlock(void *helpFile, void *helpContext, LayerPriority layerPriority, Message rejectTriggerMessage, optr rejectTriggerDestination, Message acceptTriggerMessage, optr acceptTriggerDestination, optr triggerTopText, TCHAR *arg2, TCHAR *arg1, FoamCustomDialogBoxFlags dialogFlags, optr bodyText, optr titleText, optr titleIconBitmap) in foam.goh"
	^GEOS call: helpFile with: helpContext with: layerPriority with: rejectTriggerMessage with: rejectTriggerDestination with: acceptTriggerMessage with: acceptTriggerDestination with: triggerTopText with: arg2 with: arg1 with: dialogFlags with: bodyText with: titleText with: titleIconBitmap with: #[4 0 78 3 3 1 1 2 1 2 2 3 3 1 2 2 2 2]!

CreateVisMonikerLine: pointSize with: typeFace with: numberOfFields with: columnList
	"optr pascal CreateVisMonikerLine(word pointSize, FontID typeFace, word numberOfFields, VisMonikerColumn *columnList) in foam.goh"
	^GEOS call: pointSize with: typeFace with: numberOfFields with: columnList with: #[4 0 84 1 1 1 3 2]!

CreateVisMonikerLineAdaptableColumns: pointSize with: typeFace with: numberOfFields with: columnList
	"optr pascal CreateVisMonikerLineAdaptableColumns(word pointSize, FontID typeFace, word numberOfFields, VisMonikerColumn *columnList) in foam.goh"
	^GEOS call: pointSize with: typeFace with: numberOfFields with: columnList with: #[4 0 182 1 1 1 3 2]!

FoamDisplayNote: noteText
	"void pascal FoamDisplayNote(optr noteText) in foam.goh"
	^GEOS call: noteText with: #[4 0 77 2 0]!

FoamDisplayNoteNoBlock: noteText
	"void pascal FoamDisplayNoteNoBlock(optr noteText) in foam.goh"
	^GEOS call: noteText with: #[4 0 79 2 0]!

FoamDisplayErrorNoBlock: errorText
	"void pascal FoamDisplayErrorNoBlock(optr errorText) in foam.goh"
	^GEOS call: errorText with: #[4 0 81 2 0]!

FoamDisplayWarningNoBlock: warningText
	"void pascal FoamDisplayWarningNoBlock(optr warningText) in foam.goh"
	^GEOS call: warningText with: #[4 0 80 2 0]!

FoamGetFileType: filename
	"GeosFileType pascal FoamGetFileType(TCHAR *filename) in foam.goh"
	^GEOS call: filename with: #[4 0 82 3 1]!

FoamGetHandleFileType: docHandle
	"GeosFileType pascal FoamGetHandleFileType(DocumentHandle docHandle) in foam.goh"
	^GEOS call: docHandle with: #[4 0 83 1 1]!

FoamStopSoundSequence
	"Boolean pascal FoamStopSoundSequence(void) in foam.goh"
	^GEOS call: #[4 0 117 4]!

FoamStartSoundSequence: sound with: duration with: interval
	"void pascal FoamStartSoundSequence(StandardSoundType sound, word duration, word interval) in foam.goh"
	^GEOS call: sound with: duration with: interval with: #[4 0 132 1 1 1 0]!

FoamGetLexicalOrder: theChar
	"byte pascal FoamGetLexicalOrder(char theChar) in foam.goh"
	^GEOS call: theChar with: #[4 0 122 4 1]!

FoamGenerateUniqueFilename: nameBuffer
	"void pascal FoamGenerateUniqueFilename(FileLongName *nameBuffer) in foam.goh"
	^GEOS call: nameBuffer with: #[4 0 125 3 0]!

FoamECIToMailboxError: reasonType with: reason with: mbErr with: mbErrorString
	"Boolean pascal FoamECIToMailboxError(byte reasonType, byte reason, MailboxError *mbErr, optr *mbErrorString) in foam.goh"
	^GEOS call: reasonType with: reason with: mbErr with: mbErrorString with: #[4 0 127 1 1 3 3 4]!

FoamDocStoreTextAsVMChain: docHandle with: textObject
	"word pascal FoamDocStoreTextAsVMChain(DocumentHandle docHandle, optr textObject) in foam.goh"
	^GEOS call: docHandle with: textObject with: #[4 0 130 1 2 1]!

FoamIsTextFormatted: textObject with: fontInfo
	"Boolean pascal FoamIsTextFormatted(optr textObject, DocumentFontInfo *fontInfo) in foam.goh"
	^GEOS call: textObject with: fontInfo with: #[4 0 146 2 3 4]!

FoamDocSetTextFormatted: docHandle with: fdtf with: fontInfo
	"void pascal FoamDocSetTextFormatted(DocumentHandle docHandle, FoamDocTextFormatted fdtf, DocumentFontInfo *fontInfo) in foam.goh"
	^GEOS call: docHandle with: fdtf with: fontInfo with: #[4 0 144 1 1 3 0]!

FoamSetLowSoundFlag: lowSndFlag
	"void pascal FoamSetLowSoundFlag(word lowSndFlag) in foam.goh"
	^GEOS call: lowSndFlag with: #[4 0 148 1 0]!

FoamGetLowSoundFlag
	"word pascal FoamGetLowSoundFlag(void) in foam.goh"
	^GEOS call: #[4 0 150 1]!

FoamPathMakeSP: stdPath with: pathname
	"FoamPathHandle pascal FoamPathMakeSP ( StandardPath stdPath, TCHAR *pathname ) in foam.goh"
	^GEOS call: stdPath with: pathname with: #[4 0 164 1 3 1]!

FoamPathMake: parent with: pathstr
	"FoamPathHandle pascal FoamPathMake( FoamPathHandle parent, TCHAR *pathstr ) in foam.goh"
	^GEOS call: parent with: pathstr with: #[4 0 165 1 3 1]!

FoamPathParent: fph
	"FoamPathHandle pascal FoamPathParent( FoamPathHandle fph ) in foam.goh"
	^GEOS call: fph with: #[4 0 168 1 1]!

FoamPathGetFullPath: fph with: buffer
	"StandardPath pascal FoamPathGetFullPath( FoamPathHandle fph, TCHAR *buffer) in foam.goh"
	^GEOS call: fph with: buffer with: #[4 0 166 1 3 1]!

FoamPathGetFullPathForDisplay: fph with: buffer
	"StandardPath pascal FoamPathGetFullPathForDisplay( FoamPathHandle fph, TCHAR *buffer) in foam.goh"
	^GEOS call: fph with: buffer with: #[4 0 223 1 3 1]!

FoamPathFolderName: fph with: buffer
	"void pascal FoamPathFolderName( FoamPathHandle fph, TCHAR *buffer ) in foam.goh"
	^GEOS call: fph with: buffer with: #[4 0 167 1 3 0]!

FoamPathFolderNameForDisplay: fph with: buffer
	"void pascal FoamPathFolderNameForDisplay( FoamPathHandle fph, TCHAR *buffer ) in foam.goh"
	^GEOS call: fph with: buffer with: #[4 0 224 1 3 0]!

FoamPathLock: fph
	"void pascal FoamPathLock( FoamPathHandle fph ) in foam.goh"
	^GEOS call: fph with: #[4 0 169 1 0]!

FoamPathUnlock: fph
	"void pascal FoamPathUnlock( FoamPathHandle fph ) in foam.goh"
	^GEOS call: fph with: #[4 0 170 1 0]!

FoamPathCheckLock: fph
	"word pascal FoamPathCheckLock( FoamPathHandle fph ) in foam.goh"
	^GEOS call: fph with: #[4 0 171 1 1]!

FoamPathRename: fph with: newName
	"void pascal FoamPathRename( FoamPathHandle fph, TCHAR *newName ) in foam.goh"
	^GEOS call: fph with: newName with: #[4 0 172 1 3 0]!

FoamPathIsFDD: fph
	"word pascal FoamPathIsFDD( FoamPathHandle fph ) in foam.goh"
	^GEOS call: fph with: #[4 0 173 1 1]!

FoamLaunchReaderApp: frat
	"Boolean pascal FoamLaunchReaderApp(FoamReaderAppType frat) in foam.goh"
	^GEOS call: frat with: #[4 0 175 1 4]!

FoamGetBacklightTimeout
	"int pascal FoamGetBacklightTimeout(void) in foam.goh"
	^GEOS call: #[4 0 178 4]!

FoamSetBacklightTimeout: timeoutLevel
	"void pascal FoamSetBacklightTimeout(int timeoutLevel) in foam.goh"
	^GEOS call: timeoutLevel with: #[4 0 177 4 0]!

FoamGetDocumentOutboxName: buffer
	"void pascal FoamGetDocumentOutboxName(FileLongName *buffer) in foam.goh"
	^GEOS call: buffer with: #[4 0 180 3 0]!

FoamGetCompressedDateTime: currentDate with: currentTime
	"void pascal FoamGetCompressedDateTime( TimerCompressedDate *currentDate, word *currentTime) in foam.goh"
	^GEOS call: currentDate with: currentTime with: #[4 0 190 3 3 0]!

FoamGetMinutesBetweenTimes: firstDate with: firstTime with: secondDate with: secondTime
	"dword pascal FoamGetMinutesBetweenTimes( TimerCompressedDate firstDate, word firstTime, TimerCompressedDate secondDate, word secondTime) in foam.goh"
	^GEOS call: firstDate with: firstTime with: secondDate with: secondTime with: #[4 0 187 1 1 1 1 2]!

FoamAdjustTimeForward: startDate with: startTime with: adjustment with: noticeType with: resultDate with: resultTime
	"void pascal FoamAdjustTimeForward( TimerCompressedDate startDate, word startTime, word adjustment, AdvanceNoticeType noticeType, TimerCompressedDate *resultDate, word *resultTime) in foam.goh"
	^GEOS call: startDate with: startTime with: adjustment with: noticeType with: resultDate with: resultTime with: #[4 0 188 1 1 1 1 3 3 0]!

FoamAdjustTimeBackward: startDate with: startTime with: adjustment with: noticeType with: resultDate with: resultTime
	"void pascal FoamAdjustTimeBackward( TimerCompressedDate startDate, word startTime, word adjustment, AdvanceNoticeType noticeType, TimerCompressedDate *resultDate, word *resultTime) in foam.goh"
	^GEOS call: startDate with: startTime with: adjustment with: noticeType with: resultDate with: resultTime with: #[4 0 189 1 1 1 1 3 3 0]!

FoamConvertZoomGString: zl with: hanSource with: hanType with: chunkSource
	"optr pascal FoamConvertZoomGString(ZoomLevel zl, Handle hanSource, GStringType hanType, word chunkSource) in foam.goh"
	^GEOS call: zl with: hanSource with: hanType with: chunkSource with: #[4 0 195 1 1 1 1 2]!

FoamConvertToZoomedSize: zoomLevel with: pointSize
	"WWFixedAsDWord pascal FoamConvertToZoomedSize(ZoomLevel zoomLevel, WWFixedAsDWord pointSize) in foam.goh"
	^GEOS call: zoomLevel with: pointSize with: #[4 0 196 1 2 2]!

FoamZoomSetLevel: zoomLevel
	"void pascal FoamZoomSetLevel(ZoomLevel zoomLevel) in foam.goh"
	^GEOS call: zoomLevel with: #[4 0 197 1 0]!

FoamZoomGetLevel
	"ZoomLevel pascal FoamZoomGetLevel() in foam.goh"
	^GEOS call: #[4 0 198 1]!

FoamZoomedTextWidth: text with: numChars with: zoomLevel with: pointSize
	"int pascal FoamZoomedTextWidth(TCHAR *text, int numChars, ZoomLevel zoomLevel, WWFixedAsDWord pointSize) in foam.goh"
	^GEOS call: text with: numChars with: zoomLevel with: pointSize with: #[4 0 226 3 4 1 2 4]!

FoamReplaceStringInTemplate: template with: s1 with: s2 with: s3
	"optr pascal FoamReplaceStringInTemplate( optr template, optr s1, optr s2, optr s3) in foam.goh"
	^GEOS call: template with: s1 with: s2 with: s3 with: #[4 0 201 2 2 2 2 2]!

FoamConvertValueToString: value with: lmemHandle with: flags
	"optr pascal FoamConvertValueToString( dword value, hptr lmemHandle, UtilHexToAsciiFlags flags) in foam.goh"
	^GEOS call: value with: lmemHandle with: flags with: #[4 0 202 2 1 1 2]!

FoamGetComplexMonikerBitmap: cmb
	"optr pascal FoamGetComplexMonikerBitmap(ComplexMonikerBitmap cmb) in foam.goh"
	^GEOS call: cmb with: #[4 0 205 1 2]!

FoamGetComplexMonikerText: cmt with: buffer with: bufsize
	"int pascal FoamGetComplexMonikerText(ComplexMonikerText cmt, TCHAR *buffer, int bufsize) in foam.goh"
	^GEOS call: cmt with: buffer with: bufsize with: #[4 0 206 1 3 4 4]!

FoamCheckIfOutOfSpaceOnDisk: diskHan
	"FoamDiskSpaceStatus pascal FoamCheckIfOutOfSpaceOnDisk(DiskHandle diskHan) in foam.goh"
	^GEOS call: diskHan with: #[4 0 214 1 1]!

FoamWarnIfOutOfSpaceOnDisk: diskHan
	"Boolean pascal FoamWarnIfOutOfSpaceOnDisk(DiskHandle diskHan) in foam.goh"
	^GEOS call: diskHan with: #[4 0 215 1 4]!

FoamWarnForSavingOnDisk: space with: diskHan
	"FoamSaveAction pascal FoamWarnForSavingOnDisk(dword space, DiskHandle diskHan) in foam.goh"
	^GEOS call: space with: diskHan with: #[4 0 216 2 1 1]!

FoamCancelIfNoFreeSpaceOnDisk: diskHan
	"Boolean pascal FoamCancelIfNoFreeSpaceOnDisk(DiskHandle diskHan) in foam.goh"
	^GEOS call: diskHan with: #[4 0 217 1 4]!

FoamWarnIfNotEnoughSpaceOnDisk: space with: diskHan
	"FoamDiskSpaceStatus pascal FoamWarnIfNotEnoughSpaceOnDisk(dword space, DiskHandle diskHan) in foam.goh"
	^GEOS call: space with: diskHan with: #[4 0 218 2 1 1]!

FoamWarnSpaceAfterOperationOnDisk: diskHan
	"FoamDiskSpaceStatus pascal FoamWarnSpaceAfterOperationOnDisk(DiskHandle diskHan) in foam.goh"
	^GEOS call: diskHan with: #[4 0 219 1 1]!

FoamGetFreeDiskSpaceOnDisk: diskHan
	"dword pascal FoamGetFreeDiskSpaceOnDisk(DiskHandle diskHan) in foam.goh"
	^GEOS call: diskHan with: #[4 0 220 1 2]!

FoamPlayCMTTone: cmtTone
	"void pascal FoamPlayCMTTone(FoamCMTToneType cmtTone) in foam.goh"
	^GEOS call: cmtTone with: #[4 0 229 1 0]!

!

Meta subclass: #MenuAnimation
	instanceVariableNames: ''
	classVariableNames: ''!

Gen subclass: #ComplexMoniker
	instanceVariableNames: 'complexMoniker'
	classVariableNames: ''!

VisText subclass: #UnderlinedVisText
	instanceVariableNames: ''
	classVariableNames: ''!

VisComp subclass: #VisClock
	instanceVariableNames: ''
	classVariableNames: ''!

GenFileSelector subclass: #AppLaunch
	instanceVariableNames: ''
	classVariableNames: ''!

VisContent subclass: #ClockContent
	instanceVariableNames: ''
	classVariableNames: ''!

GenFileSelector subclass: #ExtendedFileSelector
	instanceVariableNames: 'extendedFileSelector'
	classVariableNames: ''!

GenFileSelector subclass: #FFileSelector
	instanceVariableNames: ''
	classVariableNames: ''!

GenInteraction subclass: #FlashingNote
	instanceVariableNames: ''
	classVariableNames: ''!

GenApplication subclass: #FoamSubApplication
	instanceVariableNames: ''
	classVariableNames: ''!

GenValue subclass: #GenValueWithList
	instanceVariableNames: ''
	classVariableNames: ''!

GenInteraction subclass: #GreyFrame
	instanceVariableNames: ''
	classVariableNames: ''!

GenGlyph subclass: #Indicator
	instanceVariableNames: ''
	classVariableNames: ''!

GenInteraction subclass: #IndicatorInteraction
	instanceVariableNames: ''
	classVariableNames: ''!

GenItemGroup subclass: #ListWithUserDefined
	instanceVariableNames: ''
	classVariableNames: ''!

GenInteraction subclass: #PickATone
	instanceVariableNames: ''
	classVariableNames: ''!

GenGlyph subclass: #RepeatingGenGlyph
	instanceVariableNames: ''
	classVariableNames: ''!

GenInteraction subclass: #SelfDestroyingDialog
	instanceVariableNames: ''
	classVariableNames: ''!

GenText subclass: #TextWithList
	instanceVariableNames: ''
	classVariableNames: ''!

ComplexMoniker subclass: #TwoLevelTrigger
	instanceVariableNames: ''
	classVariableNames: ''!

GenText subclass: #UnderlinedGenText
	instanceVariableNames: ''
	classVariableNames: ''!

VisClock subclass: #VisAnalogClock
	instanceVariableNames: ''
	classVariableNames: ''!

GenDynamicList subclass: #FilterList
	instanceVariableNames: ''
	classVariableNames: ''!

TextWithList subclass: #FilterText
	instanceVariableNames: ''
	classVariableNames: ''!

GenControl subclass: #FoamFontControl
	instanceVariableNames: ''
	classVariableNames: ''!

GenControl subclass: #FoamJustificationControl
	instanceVariableNames: ''
	classVariableNames: ''!

GenControl subclass: #FoamPointSizeControl
	instanceVariableNames: ''
	classVariableNames: ''!

GenControl subclass: #FoamProgressDialog
	instanceVariableNames: ''
	classVariableNames: ''!

GenControl subclass: #FoamTextStyleControl
	instanceVariableNames: ''
	classVariableNames: ''!

GenPrimary subclass: #GreyGenInteraction
	instanceVariableNames: ''
	classVariableNames: ''!

Indicator subclass: #IconIndicator
	instanceVariableNames: ''
	classVariableNames: ''!

Indicator subclass: #LevelIndicator
	instanceVariableNames: ''
	classVariableNames: ''!

UnderlinedGenText subclass: #UnderlinedTextWithList
	instanceVariableNames: ''
	classVariableNames: ''!

HelpControl subclass: #FoamHelpControl
	instanceVariableNames: ''
	classVariableNames: ''!

!MenuAnimation comment!
Library foam, file foam.goh! !

!MenuAnimation class methodsFor: 'library linkage'!

library
	^4!

entry
	^227!
!

!MenuAnimation methodsFor: 'Geos instance variables'!

maiNotifyObj
	"@instance optr MAI_notifyObj"
	^self dwordAt: 4!

maiNotifyObj: value
	"@instance optr MAI_notifyObj"
	^self dwordAt: 4 put: value!

maiNotifyMsg
	"@instance Message MAI_notifyMsg"
	^self wordAt: 8!

maiNotifyMsg: value
	"@instance Message MAI_notifyMsg"
	^self wordAt: 8 put: value!

maiCurIndex
	"@instance word MAI_curIndex"
	^self wordAt: 10!

maiCurIndex: value
	"@instance word MAI_curIndex"
	^self wordAt: 10 put: value!

maiTimerHan
	"@instance TimerHandle MAI_timerHan"
	^self wordAt: 12!

maiTimerHan: value
	"@instance TimerHandle MAI_timerHan"
	^self wordAt: 12 put: value!

maiTimerID
	"@instance word MAI_timerID"
	^self wordAt: 14!

maiTimerID: value
	"@instance word MAI_timerID"
	^self wordAt: 14 put: value!

maiGstate
	"@instance GStateHandle MAI_gstate"
	^self wordAt: 16!

maiGstate: value
	"@instance GStateHandle MAI_gstate"
	^self wordAt: 16 put: value!

!

!MenuAnimation methodsFor: 'Geos vardata'!

!

!MenuAnimation methodsFor: 'Geos messages'!

animationStartAnimation: obj with: msg
	"@message void MSG_MENU_ANIMATION_START_ANIMATION(optr obj = cx:dx, Message msg = bp)"
	^self geosMessage: #[32 0 3 245 2 1 0] with: obj with: msg!

animationAdvanceAnimation
	"@message void MSG_MENU_ANIMATION_ADVANCE_ANIMATION()"
	^self geosMessage: #[32 1 2 0 0]!

animationAnimationComplete
	"@message void MSG_MENU_ANIMATION_ANIMATION_COMPLETE()"
	^self geosMessage: #[32 2 2 0 0]!

!

!ComplexMoniker comment!
Library foam, file foam.goh! !

!ComplexMoniker class methodsFor: 'library linkage'!

library
	^4!

entry
	^88!

level
	^8! !

!ComplexMoniker methodsFor: 'Geos variant class'!

complexMoniker: aClass
	complexMoniker := aClass basicNew optr: optr.!

complexMoniker
	^complexMoniker!

setVariant
	self dwordAt: 0 put: complexMoniker class classPtr asInteger.!

doesNotUnderstand: aMessage
	^complexMoniker perform: aMessage selector withArguments: aMessage arguments!

!ComplexMoniker methodsFor: 'Geos instance variables'!

cmiTextStyle
	"@instance TextStyle CMI_textStyle"
	^self byteAt: 4!

cmiTextStyle: value
	"@instance TextStyle CMI_textStyle"
	^self byteAt: 4 put: value!

cmiTopText
	"@instance word CMI_topText"
	^self wordAt: 5!

cmiTopText: value
	"@instance word CMI_topText"
	^self wordAt: 5 put: value!

cmiIconBitmap
	"@instance word CMI_iconBitmap"
	^self wordAt: 7!

cmiIconBitmap: value
	"@instance word CMI_iconBitmap"
	^self wordAt: 7 put: value!

cmiFontSize
	"@instance byte CMI_fontSize"
	^self byteAt: 9!

cmiFontSize: value
	"@instance byte CMI_fontSize"
	^self byteAt: 9 put: value!

!

!ComplexMoniker methodsFor: 'Geos vardata'!

attrComplexMonikerPlaceBitmapAtLeft
	"@vardata void ATTR_COMPLEX_MONIKER_PLACE_BITMAP_AT_LEFT"
	^self addVardata: ##attrComplexMonikerPlaceBitmapAtLeft!

attrComplexMonikerSeparatorStartPoint
	"@vardata Point ATTR_COMPLEX_MONIKER_SEPARATOR_START_POINT"
	^self addVardata: ##attrComplexMonikerSeparatorStartPoint size: 4!

attrComplexMonikerSeparatorStartPoint: aBlock
	"@vardata Point ATTR_COMPLEX_MONIKER_SEPARATOR_START_POINT"
	aBlock value: (GCSPoint forPointer: (self addVardata: ##attrComplexMonikerSeparatorStartPoint size: 4)).!

hintComplexMonikerDrawSeparator
	"@vardata void HINT_COMPLEX_MONIKER_DRAW_SEPARATOR"
	^self addVardata: ##hintComplexMonikerDrawSeparator!

hintComplexMonikerDontDrawSeparator
	"@vardata void HINT_COMPLEX_MONIKER_DONT_DRAW_SEPARATOR"
	^self addVardata: ##hintComplexMonikerDontDrawSeparator!

hintComplexMonikerCenterTextHorizontally
	"@vardata void HINT_COMPLEX_MONIKER_CENTER_TEXT_HORIZONTALLY"
	^self addVardata: ##hintComplexMonikerCenterTextHorizontally!

hintComplexMonikerMinimizeIconSpacing
	"@vardata void HINT_COMPLEX_MONIKER_MINIMIZE_ICON_SPACING"
	^self addVardata: ##hintComplexMonikerMinimizeIconSpacing!

tempComplexMonikerCurrentZoomLevel
	"@vardata void TEMP_COMPLEX_MONIKER_CURRENT_ZOOM_LEVEL"
	^self addVardata: ##tempComplexMonikerCurrentZoomLevel!

!

!ComplexMoniker methodsFor: 'Geos messages'!

monikerReplaceMoniker: retValue with: rcm
	"@message void MSG_COMPLEX_MONIKER_REPLACE_MONIKER(ReplaceComplexMonikerChunkHandles *retValue = axcxdxbp, const ReplaceComplexMoniker *rcm = dx:bp)"
	^self geosMessage: #[128 0 198 62 3 3 0] with: retValue with: rcm!

monikerGetMoniker: gcm
	"@message void MSG_COMPLEX_MONIKER_GET_MONIKER(const GetComplexMoniker *gcm = dx:bp)"
	^self geosMessage: #[128 1 2 62 3 0] with: gcm!

!

!UnderlinedVisText comment!
Library foam, file foam.goh! !

!UnderlinedVisText class methodsFor: 'library linkage'!

library
	^4!

entry
	^92!
!

!UnderlinedVisText methodsFor: 'Geos instance variables'!

!

!UnderlinedVisText methodsFor: 'Geos vardata'!

attrUnderlinedVisTextNoUnderlines
	"@vardata void ATTR_UNDERLINED_VIS_TEXT_NO_UNDERLINES"
	^self addVardata: ##attrUnderlinedVisTextNoUnderlines!

!

!UnderlinedVisText methodsFor: 'Geos messages'!

drawUnderline
	"@message void MSG_UVT_DRAW_UNDERLINE()"
	^self geosMessage: #[74 0 2 0 0]!

moveToEndIfNotFocused
	"@message void MSG_UVT_MOVE_TO_END_IF_NOT_FOCUSED()"
	^self geosMessage: #[74 1 2 0 0]!

!

!VisClock comment!
Library foam, file foam.goh! !

!VisClock class methodsFor: 'library linkage'!

library
	^4!

entry
	^103!

level
	^6! !

!VisClock methodsFor: 'Geos instance variables'!

vciTimer
	"@instance hptr VCI_timer"
	^self wordAt: 0!

vciTimer: value
	"@instance hptr VCI_timer"
	^self wordAt: 0 put: value!

vciTimerID
	"@instance word VCI_timerID"
	^self wordAt: 2!

vciTimerID: value
	"@instance word VCI_timerID"
	^self wordAt: 2 put: value!

vciTimerContinue
	"@instance VisClockContinue VCI_timerContinue"
	^self wordAt: 4!

vciTimerContinue: value
	"@instance VisClockContinue VCI_timerContinue"
	^self wordAt: 4 put: value!

vciRegion
	"@instance ChunkHandle VCI_region"
	^self wordAt: 6!

vciRegion: value
	"@instance ChunkHandle VCI_region"
	^self wordAt: 6 put: value!

vciInterval
	"@instance word VCI_interval"
	^self wordAt: 8!

vciInterval: value
	"@instance word VCI_interval"
	^self wordAt: 8 put: value!

!

!VisClock methodsFor: 'Geos vardata'!

!

!VisClock methodsFor: 'Geos messages'!

removeMe: ticks
	"@message void MSG_VC_REMOVE_ME(int ticks = cx)"
	^self geosMessage: #[96 0 2 5 4 0] with: ticks!

clockTick
	"@message void MSG_VC_CLOCK_TICK()"
	^self geosMessage: #[96 1 2 0 0]!

startTimer
	"@message void MSG_VC_START_TIMER()"
	^self geosMessage: #[96 2 2 0 0]!

stopTimer
	"@message void MSG_VC_STOP_TIMER()"
	^self geosMessage: #[96 3 2 0 0]!

!

!AppLaunch comment!
Library foam, file foam.goh! !

!AppLaunch class methodsFor: 'library linkage'!

library
	^4!

entry
	^101!
!

!AppLaunch methodsFor: 'Geos instance variables'!

aliLauncherApp
	"@instance FApplication ALI_launcherApp"
	^self wordAt: 64!

aliLauncherApp: value
	"@instance FApplication ALI_launcherApp"
	^self wordAt: 64 put: value!

aliTriggerObj
	"@instance optr ALI_triggerObj"
	^self dwordAt: 66!

aliTriggerObj: value
	"@instance optr ALI_triggerObj"
	^self dwordAt: 66 put: value!

!

!AppLaunch methodsFor: 'Geos vardata'!

!

!AppLaunch methodsFor: 'Geos messages'!

launchSelectedApp
	"@message void MSG_AL_LAUNCH_SELECTED_APP()"
	^self geosMessage: #[106 0 2 0 0]!

appSelected
	"@message void MSG_AL_APP_SELECTED()"
	^self geosMessage: #[106 1 2 0 0]!

!

!ClockContent comment!
Library foam, file foam.goh! !

!ClockContent class methodsFor: 'library linkage'!

library
	^4!

entry
	^105!
!

!ClockContent methodsFor: 'Geos instance variables'!

caiCurClock
	"@instance optr CAI_curClock"
	^self dwordAt: 115!

caiCurClock: value
	"@instance optr CAI_curClock"
	^self dwordAt: 115 put: value!

caiInterval
	"@instance word CAI_interval"
	^self wordAt: 119!

caiInterval: value
	"@instance word CAI_interval"
	^self wordAt: 119 put: value!

!

!ClockContent methodsFor: 'Geos vardata'!

!

!ClockContent methodsFor: 'Geos messages'!

!

!ExtendedFileSelector comment!
Library foam, file foam.goh! !

!ExtendedFileSelector class methodsFor: 'library linkage'!

library
	^4!

entry
	^153!

level
	^8! !

!ExtendedFileSelector methodsFor: 'Geos variant class'!

extendedFileSelector: aClass
	extendedFileSelector := aClass basicNew optr: optr.!

extendedFileSelector
	^extendedFileSelector!

setVariant
	self dwordAt: 0 put: extendedFileSelector class classPtr asInteger.!

doesNotUnderstand: aMessage
	^extendedFileSelector perform: aMessage selector withArguments: aMessage arguments!

!ExtendedFileSelector methodsFor: 'Geos instance variables'!

efsiAttrs
	"@instance ExtendedFileSelectorAttrs EFSI_attrs"
	^self wordAt: 4!

efsiAttrs: value
	"@instance ExtendedFileSelectorAttrs EFSI_attrs"
	^self wordAt: 4 put: value!

efsiSelections
	"@instance ChunkHandle EFSI_selections"
	^self wordAt: 6!

efsiSelections: value
	"@instance ChunkHandle EFSI_selections"
	^self wordAt: 6 put: value!

!

!ExtendedFileSelector methodsFor: 'Geos vardata'!

hintEfsShortSearchMoniker
	"@vardata void HINT_EFS_SHORT_SEARCH_MONIKER"
	^self addVardata: ##hintEfsShortSearchMoniker!

!

!ExtendedFileSelector methodsFor: 'Geos messages'!

getMultipleSelections: selections with: bufLength
	"@message word MSG_EFS_GET_MULTIPLE_SELECTIONS(ExtendedFileSelectorEntry *selections = cx:dx, word bufLength = bp)= ax"
	^self geosMessage: #[128 0 99 245 3 1 1] with: selections with: bufLength!

getAttrs
	"@message ExtendedFileSelectorAttrs MSG_EFS_GET_ATTRS()= cx"
	^self geosMessage: #[128 1 102 0 1]!

setAttrs: set with: clear
	"@message void MSG_EFS_SET_ATTRS(ExtendedFileSelectorAttrs set = cx, ExtendedFileSelectorAttrs clear = dx)"
	^self geosMessage: #[128 2 2 53 1 1 0] with: set with: clear!

getNumSelections
	"@message word MSG_EFS_GET_NUM_SELECTIONS()= ax"
	^self geosMessage: #[128 3 98 0 1]!

getMultipleSelectionsBlock
	"@message ExtendedFileSelectorEntryData MSG_EFS_GET_MULTIPLE_SELECTIONS_BLOCK()= cx:ax"
	^self geosMessage: #[128 4 146 0 2]!

resetSearch
	"@message void MSG_EFS_RESET_SEARCH()"
	^self geosMessage: #[128 5 2 0 0]!

getSelectionInfo: retValue
	"@message void MSG_EFS_GET_SELECTION_INFO(EFSSelectionInfo *retValue=cxdxbpax)"
	^self geosMessage: #[128 6 202 0 3 0] with: retValue!

!

!FFileSelector comment!
Library foam, file foam.goh! !

!FFileSelector class methodsFor: 'library linkage'!

library
	^4!

entry
	^87!
!

!FFileSelector methodsFor: 'Geos instance variables'!

!

!FFileSelector methodsFor: 'Geos vardata'!

attrFfsDocumentDir: value
	"@vardata FDocumentDir ATTR_FFS_DOCUMENT_DIR"
	^self addVardata: ##attrFfsDocumentDir word: value!

!

!FFileSelector methodsFor: 'Geos messages'!

setPath: fDocDir
	"@message void MSG_FFS_SET_PATH(FDocumentDir fDocDir = cx)"
	^self geosMessage: #[106 0 2 5 1 0] with: fDocDir!

getPath
	"@message FDocumentDir MSG_FFS_GET_PATH()= cx"
	^self geosMessage: #[106 1 102 0 1]!

open
	"@message void MSG_FFS_OPEN()"
	^self geosMessage: #[106 2 2 0 0]!

!

!FlashingNote comment!
Library foam, file foam.goh! !

!FlashingNote class methodsFor: 'library linkage'!

library
	^4!

entry
	^109!
!

!FlashingNote methodsFor: 'Geos instance variables'!

fniDuration
	"@instance word FNI_duration"
	^self wordAt: 21!

fniDuration: value
	"@instance word FNI_duration"
	^self wordAt: 21 put: value!

!

!FlashingNote methodsFor: 'Geos vardata'!

hintFlashingNoteDestroySelfAfterDismiss
	"@vardata void HINT_FLASHING_NOTE_DESTROY_SELF_AFTER_DISMISS"
	^self addVardata: ##hintFlashingNoteDestroySelfAfterDismiss!

attrFlashingNoteMinimumDuration: value
	"@vardata word ATTR_FLASHING_NOTE_MINIMUM_DURATION"
	^self addVardata: ##attrFlashingNoteMinimumDuration word: value!

tempFlashingNoteTimerData
	"@vardata FlashingNoteTimerData TEMP_FLASHING_NOTE_TIMER_DATA"
	^self addVardata: ##tempFlashingNoteTimerData size: 4!

tempFlashingNoteTimerData: aBlock
	"@vardata FlashingNoteTimerData TEMP_FLASHING_NOTE_TIMER_DATA"
	aBlock value: (GCSFlashingNoteTimerData forPointer: (self addVardata: ##tempFlashingNoteTimerData size: 4)).!

tempFlashingNoteDismissActionOk
	"@vardata void TEMP_FLASHING_NOTE_DISMISS_ACTION_OK"
	^self addVardata: ##tempFlashingNoteDismissActionOk!

tempFlashingNoteTriedDismiss
	"@vardata void TEMP_FLASHING_NOTE_TRIED_DISMISS"
	^self addVardata: ##tempFlashingNoteTriedDismiss!

tempFlashingNoteAltMargins
	"@vardata void TEMP_FLASHING_NOTE_ALT_MARGINS"
	^self addVardata: ##tempFlashingNoteAltMargins!

!

!FlashingNote methodsFor: 'Geos messages'!

noteSetDuration: ticks
	"@message void MSG_FLASHING_NOTE_SET_DURATION(int ticks = cx)"
	^self geosMessage: #[106 0 2 5 4 0] with: ticks!

noteAcceptUserAction
	"@message void MSG_FLASHING_NOTE_ACCEPT_USER_ACTION()"
	^self geosMessage: #[106 1 2 0 0]!

noteDismissDialog: timerID
	"@message void MSG_FLASHING_NOTE_DISMISS_DIALOG(int timerID = bp)"
	^self geosMessage: #[106 2 2 7 4 0] with: timerID!

noteDismissDialogNow
	"@message void MSG_FLASHING_NOTE_DISMISS_DIALOG_NOW()"
	^self geosMessage: #[106 3 2 0 0]!

!

!FoamSubApplication comment!
Library foam, file foam.goh! !

!FoamSubApplication class methodsFor: 'library linkage'!

library
	^4!

entry
	^128!
!

!FoamSubApplication methodsFor: 'Geos instance variables'!

fsaiLauncherApp
	"@instance FApplication FSAI_launcherApp"
	^self wordAt: 271!

fsaiLauncherApp: value
	"@instance FApplication FSAI_launcherApp"
	^self wordAt: 271 put: value!

!

!FoamSubApplication methodsFor: 'Geos vardata'!

tempFoamSubAppNotDefaultLaunchable
	"@vardata void TEMP_FOAM_SUB_APP_NOT_DEFAULT_LAUNCHABLE"
	^self addVardata: ##tempFoamSubAppNotDefaultLaunchable!

!

!FoamSubApplication methodsFor: 'Geos messages'!

returnToLauncher
	"@message void MSG_FSA_RETURN_TO_LAUNCHER()"
	^self geosMessage: #[106 0 2 0 0]!

!

!GenValueWithList comment!
Library foam, file foam.goh! !

!GenValueWithList class methodsFor: 'library linkage'!

library
	^4!

entry
	^106!
!

!GenValueWithList methodsFor: 'Geos instance variables'!

gvwlcListObj
	"@instance optr GVWLC_listObj"
	^self dwordAt: 42!

gvwlcListObj: value
	"@instance optr GVWLC_listObj"
	^self dwordAt: 42 put: value!

!

!GenValueWithList methodsFor: 'Geos vardata'!

attrGenValueWithListDoNotAllowNavigation
	"@vardata void ATTR_GEN_VALUE_WITH_LIST_DO_NOT_ALLOW_NAVIGATION"
	^self addVardata: ##attrGenValueWithListDoNotAllowNavigation!

attrGenValueWithListMaxTextLen: value
	"@vardata word ATTR_GEN_VALUE_WITH_LIST_MAX_TEXT_LEN"
	^self addVardata: ##attrGenValueWithListMaxTextLen word: value!

!

!GenValueWithList methodsFor: 'Geos messages'!

!

!GreyFrame comment!
Library foam, file foam.goh! !

!GreyFrame class methodsFor: 'library linkage'!

library
	^4!

entry
	^89!
!

!GreyFrame methodsFor: 'Geos instance variables'!

!

!GreyFrame methodsFor: 'Geos vardata'!

attrGreyFrameFlatFrameLook
	"@vardata void ATTR_GREY_FRAME_FLAT_FRAME_LOOK"
	^self addVardata: ##attrGreyFrameFlatFrameLook!

!

!GreyFrame methodsFor: 'Geos messages'!

!

!Indicator comment!
Library foam, file foam.goh! !

!Indicator class methodsFor: 'library linkage'!

library
	^4!

entry
	^95!
!

!Indicator methodsFor: 'Geos instance variables'!

iiNumIcons
	"@instance IconsShown II_numIcons"
	^self byteAt: 18!

iiNumIcons: value
	"@instance IconsShown II_numIcons"
	^self byteAt: 18 put: value!

!

!Indicator methodsFor: 'Geos vardata'!

!

!Indicator methodsFor: 'Geos messages'!

!

!IndicatorInteraction comment!
Library foam, file foam.goh! !

!IndicatorInteraction class methodsFor: 'library linkage'!

library
	^4!

entry
	^139!
!

!IndicatorInteraction methodsFor: 'Geos instance variables'!

!

!IndicatorInteraction methodsFor: 'Geos vardata'!

!

!IndicatorInteraction methodsFor: 'Geos messages'!

!

!ListWithUserDefined comment!
Library foam, file foam.goh! !

!ListWithUserDefined class methodsFor: 'library linkage'!

library
	^4!

entry
	^100!
!

!ListWithUserDefined methodsFor: 'Geos instance variables'!

lwudiTextObj
	"@instance optr LWUDI_textObj"
	^self dwordAt: 30!

lwudiTextObj: value
	"@instance optr LWUDI_textObj"
	^self dwordAt: 30 put: value!

lwudiTextID
	"@instance word LWUDI_textID"
	^self wordAt: 34!

lwudiTextID: value
	"@instance word LWUDI_textID"
	^self wordAt: 34 put: value!

!

!ListWithUserDefined methodsFor: 'Geos vardata'!

attrListWithUserDefinedTextObjectSelected
	"@vardata void ATTR_LIST_WITH_USER_DEFINED_TEXT_OBJECT_SELECTED"
	^self addVardata: ##attrListWithUserDefinedTextObjectSelected!

!

!ListWithUserDefined methodsFor: 'Geos messages'!

setSingleSelectionOrUserDefined: identifier with: indeterminate
	"@message void MSG_LWUD_SET_SINGLE_SELECTION_OR_USER_DEFINED( word identifier = cx, Boolean indeterminate = dx)"
	^self geosMessage: #[106 0 2 53 1 4 0] with: identifier with: indeterminate!

!

!PickATone comment!
Library foam, file foam.goh! !

!PickATone class methodsFor: 'library linkage'!

library
	^4!

entry
	^191!
!

!PickATone methodsFor: 'Geos instance variables'!

patiList
	"@instance optr PATI_list"
	^self dwordAt: 21!

patiList: value
	"@instance optr PATI_list"
	^self dwordAt: 21 put: value!

patiType
	"@instance PickAToneType PATI_type"
	^self wordAt: 25!

patiType: value
	"@instance PickAToneType PATI_type"
	^self wordAt: 25 put: value!

patiToneArray
	"@instance ChunkHandle PATI_toneArray"
	^self wordAt: 27!

patiToneArray: value
	"@instance ChunkHandle PATI_toneArray"
	^self wordAt: 27 put: value!

patiSelection
	"@instance word PATI_selection"
	^self wordAt: 29!

patiSelection: value
	"@instance word PATI_selection"
	^self wordAt: 29 put: value!

patiToneName
	"@instance ToneName PATI_toneName"
	^GCSToneName forPointer: (self ptrAt: 31).!

patiToneName: aBlock
	"@instance ToneName PATI_toneName"
	aBlock value: (GCSToneName forPointer: (self ptrAt: 31)).!

patiLongTones
	"@instance Boolean PATI_longTones"
	^self wordAt: 68!

patiLongTones: value
	"@instance Boolean PATI_longTones"
	^self wordAt: 68 put: value!

patiTimerID
	"@instance word PATI_timerID"
	^self wordAt: 70!

patiTimerID: value
	"@instance word PATI_timerID"
	^self wordAt: 70 put: value!

patiTimerHandle
	"@instance hptr PATI_timerHandle"
	^self wordAt: 72!

patiTimerHandle: value
	"@instance hptr PATI_timerHandle"
	^self wordAt: 72 put: value!

patiTimerTone
	"@instance word PATI_timerTone"
	^self wordAt: 74!

patiTimerTone: value
	"@instance word PATI_timerTone"
	^self wordAt: 74 put: value!

!

!PickATone methodsFor: 'Geos vardata'!

!

!PickATone methodsFor: 'Geos messages'!

needMoniker: theList with: index
	"@message void MSG_PAT_NEED_MONIKER(optr theList = cx:dx, word index = bp)"
	^self geosMessage: #[106 0 3 245 2 1 0] with: theList with: index!

toneSelected: index
	"@message void MSG_PAT_TONE_SELECTED(word index = cx)"
	^self geosMessage: #[106 1 2 5 1 0] with: index!

closeInteraction
	"@message void MSG_PAT_CLOSE_INTERACTION()"
	^self geosMessage: #[106 2 2 0 0]!

initDynamicList
	"@message void MSG_PAT_INIT_DYNAMIC_LIST()"
	^self geosMessage: #[106 3 2 0 0]!

getToneName: toneName
	"@message void MSG_PAT_GET_TONE_NAME(ToneName *toneName = cx:dx)"
	^self geosMessage: #[106 4 2 53 3 0] with: toneName!

setToneName: toneName with: realTone
	"@message void MSG_PAT_SET_TONE_NAME(TCHAR *toneName = cx:dx, Boolean realTone = bp)"
	^self geosMessage: #[106 5 3 245 3 4 0] with: toneName with: realTone!

setToDefault
	"@message void MSG_PAT_SET_TO_DEFAULT()"
	^self geosMessage: #[106 6 2 0 0]!

setToNone
	"@message void MSG_PAT_SET_TO_NONE()"
	^self geosMessage: #[106 7 2 0 0]!

playSampling: index with: numSelections with: flags
	"@message void MSG_PAT_PLAY_SAMPLING(word index = cx, word numSelections = bp, GenItemGroupStateFlags flags = dx)"
	^self geosMessage: #[106 8 3 189 1 1 1 0] with: index with: numSelections with: flags!

setRingingTone
	"@message void MSG_PAT_SET_RINGING_TONE()"
	^self geosMessage: #[106 9 2 0 0]!

ringingToneStatus: value
	"@message void MSG_PAT_RINGING_TONE_STATUS(word value = dx)"
	^self geosMessage: #[106 10 2 6 1 0] with: value!

playDelayedSampling: tickCount with: timerID
	"@message void MSG_PAT_PLAY_DELAYED_SAMPLING(dword tickCount = cx.dx, word timerID = bp)"
	^self geosMessage: #[106 11 3 245 2 1 0] with: tickCount with: timerID!

!

!RepeatingGenGlyph comment!
Library foam, file foam.goh! !

!RepeatingGenGlyph class methodsFor: 'library linkage'!

library
	^4!

entry
	^90!
!

!RepeatingGenGlyph methodsFor: 'Geos instance variables'!

rggiCurrentItem
	"@instance word RGGI_currentItem"
	^self wordAt: 18!

rggiCurrentItem: value
	"@instance word RGGI_currentItem"
	^self wordAt: 18 put: value!

rggiTimerHandle
	"@instance word RGGI_timerHandle"
	^self wordAt: 20!

rggiTimerHandle: value
	"@instance word RGGI_timerHandle"
	^self wordAt: 20 put: value!

rggiTimerID
	"@instance word RGGI_timerID"
	^self wordAt: 22!

rggiTimerID: value
	"@instance word RGGI_timerID"
	^self wordAt: 22 put: value!

rggiDelayTime
	"@instance word RGGI_delayTime"
	^self wordAt: 24!

rggiDelayTime: value
	"@instance word RGGI_delayTime"
	^self wordAt: 24 put: value!

rggiMonikerList
	"@instance @visMoniker RGGI_monikerList"
	^self wordAt: 26!

rggiMonikerList: value
	"@instance @visMoniker RGGI_monikerList"
	^self wordAt: 26 put: value!

!

!RepeatingGenGlyph methodsFor: 'Geos vardata'!

!

!RepeatingGenGlyph methodsFor: 'Geos messages'!

stopAnimation
	"@message void MSG_RGG_STOP_ANIMATION()"
	^self geosMessage: #[106 0 2 0 0]!

startAnimation
	"@message void MSG_RGG_START_ANIMATION()"
	^self geosMessage: #[106 1 2 0 0]!

changeMoniker
	"@message void MSG_RGG_CHANGE_MONIKER()"
	^self geosMessage: #[106 2 2 0 0]!

!

!SelfDestroyingDialog comment!
Library foam, file foam.goh! !

!SelfDestroyingDialog class methodsFor: 'library linkage'!

library
	^4!

entry
	^110!
!

!SelfDestroyingDialog methodsFor: 'Geos instance variables'!

!

!SelfDestroyingDialog methodsFor: 'Geos vardata'!

!

!SelfDestroyingDialog methodsFor: 'Geos messages'!

!

!TextWithList comment!
Library foam, file foam.goh! !

!TextWithList class methodsFor: 'library linkage'!

library
	^4!

entry
	^98!
!

!TextWithList methodsFor: 'Geos instance variables'!

twlcListObj
	"@instance optr TWLC_listObj"
	^self dwordAt: 30!

twlcListObj: value
	"@instance optr TWLC_listObj"
	^self dwordAt: 30 put: value!

!

!TextWithList methodsFor: 'Geos vardata'!

attrTextWithListDoNotAllowNavigation
	"@vardata void ATTR_TEXT_WITH_LIST_DO_NOT_ALLOW_NAVIGATION"
	^self addVardata: ##attrTextWithListDoNotAllowNavigation!

!

!TextWithList methodsFor: 'Geos messages'!

!

!TwoLevelTrigger comment!
Library foam, file foam.goh! !

!TwoLevelTrigger class methodsFor: 'library linkage'!

library
	^4!

entry
	^93!
!

!TwoLevelTrigger methodsFor: 'Geos instance variables'!

tltiOther_parent
	"@instance optr TLTI_other_parent"
	^self dwordAt: 10!

tltiOther_parent: value
	"@instance optr TLTI_other_parent"
	^self dwordAt: 10 put: value!

!

!TwoLevelTrigger methodsFor: 'Geos vardata'!

attrTltIsBackTrigger
	"@vardata void ATTR_TLT_IS_BACK_TRIGGER"
	^self addVardata: ##attrTltIsBackTrigger!

!

!TwoLevelTrigger methodsFor: 'Geos messages'!

activateOtherLevel
	"@message void MSG_TLT_ACTIVATE_OTHER_LEVEL()"
	^self geosMessage: #[136 0 2 0 0]!

!

!UnderlinedGenText comment!
Library foam, file foam.goh! !

!UnderlinedGenText class methodsFor: 'library linkage'!

library
	^4!

entry
	^91!
!

!UnderlinedGenText methodsFor: 'Geos instance variables'!

!

!UnderlinedGenText methodsFor: 'Geos vardata'!

!

!UnderlinedGenText methodsFor: 'Geos messages'!

!

!VisAnalogClock comment!
Library foam, file foam.goh! !

!VisAnalogClock class methodsFor: 'library linkage'!

library
	^4!

entry
	^104!
!

!VisAnalogClock methodsFor: 'Geos instance variables'!

vaciPattern
	"@instance ChunkHandle VACI_pattern"
	^self wordAt: 10!

vaciPattern: value
	"@instance ChunkHandle VACI_pattern"
	^self wordAt: 10 put: value!

vaciHourHand
	"@instance ChunkHandle VACI_hourHand"
	^self wordAt: 12!

vaciHourHand: value
	"@instance ChunkHandle VACI_hourHand"
	^self wordAt: 12 put: value!

vaciMinuteHand
	"@instance ChunkHandle VACI_minuteHand"
	^self wordAt: 14!

vaciMinuteHand: value
	"@instance ChunkHandle VACI_minuteHand"
	^self wordAt: 14 put: value!

vaciSecondHand
	"@instance ChunkHandle VACI_secondHand"
	^self wordAt: 16!

vaciSecondHand: value
	"@instance ChunkHandle VACI_secondHand"
	^self wordAt: 16 put: value!

vaciXScale
	"@instance WWFixed VACI_xScale"
	^GCSWWFixed forPointer: (self ptrAt: 18).!

vaciXScale: aBlock
	"@instance WWFixed VACI_xScale"
	aBlock value: (GCSWWFixed forPointer: (self ptrAt: 18)).!

vaciYScale
	"@instance WWFixed VACI_yScale"
	^GCSWWFixed forPointer: (self ptrAt: 22).!

vaciYScale: aBlock
	"@instance WWFixed VACI_yScale"
	aBlock value: (GCSWWFixed forPointer: (self ptrAt: 22)).!

vaciAspectRatio
	"@instance WWFixed VACI_aspectRatio"
	^GCSWWFixed forPointer: (self ptrAt: 26).!

vaciAspectRatio: aBlock
	"@instance WWFixed VACI_aspectRatio"
	aBlock value: (GCSWWFixed forPointer: (self ptrAt: 26)).!

vaciLastHourAngle
	"@instance word VACI_lastHourAngle"
	^self wordAt: 30!

vaciLastHourAngle: value
	"@instance word VACI_lastHourAngle"
	^self wordAt: 30 put: value!

vaciLastMinuteAngle
	"@instance word VACI_lastMinuteAngle"
	^self wordAt: 32!

vaciLastMinuteAngle: value
	"@instance word VACI_lastMinuteAngle"
	^self wordAt: 32 put: value!

vaciLastSecondAngle
	"@instance word VACI_lastSecondAngle"
	^self wordAt: 34!

vaciLastSecondAngle: value
	"@instance word VACI_lastSecondAngle"
	^self wordAt: 34 put: value!

vaciDiameter
	"@instance word VACI_diameter"
	^self wordAt: 36!

vaciDiameter: value
	"@instance word VACI_diameter"
	^self wordAt: 36 put: value!

!

!VisAnalogClock methodsFor: 'Geos vardata'!

attrAnalogClockShowAmPm
	"@vardata Point ATTR_ANALOG_CLOCK_SHOW_AM_PM"
	^self addVardata: ##attrAnalogClockShowAmPm size: 4!

attrAnalogClockShowAmPm: aBlock
	"@vardata Point ATTR_ANALOG_CLOCK_SHOW_AM_PM"
	aBlock value: (GCSPoint forPointer: (self addVardata: ##attrAnalogClockShowAmPm size: 4)).!

!

!VisAnalogClock methodsFor: 'Geos messages'!

!

!FilterList comment!
Library foam, file foam.goh! !

!FilterList class methodsFor: 'library linkage'!

library
	^4!

entry
	^151!
!

!FilterList methodsFor: 'Geos instance variables'!

fliNoItemsMoniker
	"@instance @visMoniker FLI_noItemsMoniker"
	^self wordAt: 34!

fliNoItemsMoniker: value
	"@instance @visMoniker FLI_noItemsMoniker"
	^self wordAt: 34 put: value!

fliNoMatchMoniker
	"@instance @visMoniker FLI_noMatchMoniker"
	^self wordAt: 36!

fliNoMatchMoniker: value
	"@instance @visMoniker FLI_noMatchMoniker"
	^self wordAt: 36 put: value!

fliCurrentNoneMoniker
	"@instance word FLI_currentNoneMoniker"
	^self wordAt: 38!

fliCurrentNoneMoniker: value
	"@instance word FLI_currentNoneMoniker"
	^self wordAt: 38 put: value!

fliFilterItems
	"@instance ChunkHandle FLI_filterItems"
	^self wordAt: 40!

fliFilterItems: value
	"@instance ChunkHandle FLI_filterItems"
	^self wordAt: 40 put: value!

!

!FilterList methodsFor: 'Geos vardata'!

attrFilterListCustomIdentifiers
	"@vardata FilterListCustomIdentifiers ATTR_FILTER_LIST_CUSTOM_IDENTIFIERS"
	^self addVardata: ##attrFilterListCustomIdentifiers size: 4!

attrFilterListCustomIdentifiers: aBlock
	"@vardata FilterListCustomIdentifiers ATTR_FILTER_LIST_CUSTOM_IDENTIFIERS"
	aBlock value: (GCSFilterListCustomIdentifiers forPointer: (self addVardata: ##attrFilterListCustomIdentifiers size: 4)).!

!

!FilterList methodsFor: 'Geos messages'!

listMapPhysicalToApp: id
	"@message word MSG_FILTER_LIST_MAP_PHYSICAL_TO_APP(word id = cx)= cx"
	^self geosMessage: #[108 0 102 5 1 1] with: id!

listMapAppToPhysical: id
	"@message word MSG_FILTER_LIST_MAP_APP_TO_PHYSICAL(word id = cx)= cx"
	^self geosMessage: #[108 1 102 5 1 1] with: id!

listSetSingleSelection: identifier with: indeterminate
	"@message void MSG_FILTER_LIST_SET_SINGLE_SELECTION(word identifier = cx, Boolean indeterminate = dx)"
	^self geosMessage: #[108 2 2 53 1 4 0] with: identifier with: indeterminate!

listSetMultipleSelections: selectionList with: numSelections
	"@message void MSG_FILTER_LIST_SET_MULTIPLE_SELECTIONS( word *selectionList = cx:dx, word numSelections = bp)"
	^self geosMessage: #[108 3 3 245 3 1 0] with: selectionList with: numSelections!

listGetSelection
	"@message word MSG_FILTER_LIST_GET_SELECTION()= ax"
	^self geosMessage: #[108 4 98 0 1]!

listGetMultipleSelections: selectionList with: maxSelections
	"@message word MSG_FILTER_LIST_GET_MULTIPLE_SELECTIONS( word *selectionList = cx:dx, word maxSelections = bp)= ax"
	^self geosMessage: #[108 5 99 245 3 1 1] with: selectionList with: maxSelections!

listGetItemOptr: identifier
	"@message optr MSG_FILTER_LIST_GET_ITEM_OPTR(word identifier = cx)= cx:dx"
	^self geosMessage: #[108 6 154 5 1 2] with: identifier!

listSetItemState: identifier with: state
	"@message void MSG_FILTER_LIST_SET_ITEM_STATE(word identifier = cx, Boolean state = dx)"
	^self geosMessage: #[108 7 2 53 1 4 0] with: identifier with: state!

listIsItemSelected: identifier
	"@message Boolean MSG_FILTER_LIST_IS_ITEM_SELECTED(word identifier = cx)= carry"
	^self geosMessage: #[108 8 2 5 1 4] with: identifier!

listMakeItemVisible: identifier
	"@message void MSG_FILTER_LIST_MAKE_ITEM_VISIBLE(word identifier = cx)"
	^self geosMessage: #[108 9 2 5 1 0] with: identifier!

listReplaceItemMoniker: item with: flags with: height with: width with: length with: dataType with: sourceType with: source
	"@message void MSG_FILTER_LIST_REPLACE_ITEM_MONIKER(@stack word item, ReplaceItemMonikerFlags flags, word height, word width, word length, VisMonikerDataType dataType, VisMonikerSourceType sourceType, dword source)"
	^self geosMessage: #[108 10 0 18 1 1 1 1 1 1 1 2 0] with: item with: flags with: height with: width with: length with: dataType with: sourceType with: source!

listReplaceItemMonikerOptr: item with: moniker
	"@message void MSG_FILTER_LIST_REPLACE_ITEM_MONIKER_OPTR(word item = bp, optr moniker = cx:dx)"
	^self geosMessage: #[108 11 3 175 1 2 0] with: item with: moniker!

listReplaceItemText: item with: text
	"@message void MSG_FILTER_LIST_REPLACE_ITEM_TEXT(word item = bp, char *text = cx:dx)"
	^self geosMessage: #[108 12 3 175 1 3 0] with: item with: text!

listGetFocusItem
	"@message word MSG_FILTER_LIST_GET_FOCUS_ITEM()= cx"
	^self geosMessage: #[108 13 102 0 1]!

listSetFocusItem: identifier
	"@message void MSG_FILTER_LIST_SET_FOCUS_ITEM(word identifier = cx)"
	^self geosMessage: #[108 14 2 5 1 0] with: identifier!

listInitialize: numItems with: filter
	"@message void MSG_FILTER_LIST_INITIALIZE(word numItems = cx, word *filter = dx:bp)"
	^self geosMessage: #[108 15 3 245 1 3 0] with: numItems with: filter!

!

!FilterText comment!
Library foam, file foam.goh! !

!FilterText class methodsFor: 'library linkage'!

library
	^4!

entry
	^152!
!

!FilterText methodsFor: 'Geos instance variables'!

ftiFilterTimeout
	"@instance word FTI_filterTimeout"
	^self wordAt: 34!

ftiFilterTimeout: value
	"@instance word FTI_filterTimeout"
	^self wordAt: 34 put: value!

ftiFilterMsg
	"@instance Message FTI_filterMsg"
	^self wordAt: 36!

ftiFilterMsg: value
	"@instance Message FTI_filterMsg"
	^self wordAt: 36 put: value!

ftiTimerID
	"@instance word FTI_timerID"
	^self wordAt: 38!

ftiTimerID: value
	"@instance word FTI_timerID"
	^self wordAt: 38 put: value!

ftiTimerHandle
	"@instance word FTI_timerHandle"
	^self wordAt: 40!

ftiTimerHandle: value
	"@instance word FTI_timerHandle"
	^self wordAt: 40 put: value!

!

!FilterText methodsFor: 'Geos vardata'!

!

!FilterText methodsFor: 'Geos messages'!

textSendFilterMsg
	"@message void MSG_FILTER_TEXT_SEND_FILTER_MSG()"
	^self geosMessage: #[108 0 2 0 0]!

textReset
	"@message void MSG_FILTER_TEXT_RESET()"
	^self geosMessage: #[108 1 2 0 0]!

textResetTextIfNotFocused
	"@message void MSG_FILTER_TEXT_RESET_TEXT_IF_NOT_FOCUSED()"
	^self geosMessage: #[108 2 2 0 0]!

!

!FoamFontControl comment!
Library foam, file foam.goh! !

!FoamFontControl class methodsFor: 'library linkage'!

library
	^4!

entry
	^114!
!

!FoamFontControl methodsFor: 'Geos instance variables'!

!

!FoamFontControl methodsFor: 'Geos vardata'!

attrFoamFontControlShortListFontType: value
	"@vardata FontEnumFlags ATTR_FOAM_FONT_CONTROL_SHORT_LIST_FONT_TYPE"
	^self addVardata: ##attrFoamFontControlShortListFontType byte: value!

!

!FoamFontControl methodsFor: 'Geos messages'!

setFont: fontID
	"@message void MSG_FFC_SET_FONT(word fontID = cx)"
	^self geosMessage: #[108 0 2 5 1 0] with: fontID!

!

!FoamJustificationControl comment!
Library foam, file foam.goh! !

!FoamJustificationControl class methodsFor: 'library linkage'!

library
	^4!

entry
	^113!
!

!FoamJustificationControl methodsFor: 'Geos instance variables'!

!

!FoamJustificationControl methodsFor: 'Geos vardata'!

!

!FoamJustificationControl methodsFor: 'Geos messages'!

setJustification
	"@message void MSG_FJC_SET_JUSTIFICATION()"
	^self geosMessage: #[108 0 2 0 0]!

!

!FoamPointSizeControl comment!
Library foam, file foam.goh! !

!FoamPointSizeControl class methodsFor: 'library linkage'!

library
	^4!

entry
	^108!
!

!FoamPointSizeControl methodsFor: 'Geos instance variables'!

!

!FoamPointSizeControl methodsFor: 'Geos vardata'!

!

!FoamPointSizeControl methodsFor: 'Geos messages'!

setPointSize: size
	"@message void MSG_FPSC_SET_POINT_SIZE(WWFixed size = dx:cx)"
	^self geosMessage: #[108 0 2 46 2 0] with: size!

setPointSizeFromList: size
	"@message void MSG_FPSC_SET_POINT_SIZE_FROM_LIST(word size = cx)"
	^self geosMessage: #[108 1 2 5 1 0] with: size!

!

!FoamProgressDialog comment!
Library foam, file foam.goh! !

!FoamProgressDialog class methodsFor: 'library linkage'!

library
	^4!

entry
	^123!
!

!FoamProgressDialog methodsFor: 'Geos instance variables'!

fpdiDescriptionText
	"@instance ChunkHandle FPDI_descriptionText"
	^self wordAt: 25!

fpdiDescriptionText: value
	"@instance ChunkHandle FPDI_descriptionText"
	^self wordAt: 25 put: value!

fpdiStatusText
	"@instance ChunkHandle FPDI_statusText"
	^self wordAt: 27!

fpdiStatusText: value
	"@instance ChunkHandle FPDI_statusText"
	^self wordAt: 27 put: value!

fpdiCancelDestination
	"@instance optr FPDI_cancelDestination"
	^self dwordAt: 29!

fpdiCancelDestination: value
	"@instance optr FPDI_cancelDestination"
	^self dwordAt: 29 put: value!

fpdiCancelActionMsg
	"@instance word FPDI_cancelActionMsg"
	^self wordAt: 33!

fpdiCancelActionMsg: value
	"@instance word FPDI_cancelActionMsg"
	^self wordAt: 33 put: value!

!

!FoamProgressDialog methodsFor: 'Geos vardata'!

hintFoamProgressDialogDestroySelfAfterDismiss
	"@vardata void HINT_FOAM_PROGRESS_DIALOG_DESTROY_SELF_AFTER_DISMISS"
	^self addVardata: ##hintFoamProgressDialogDestroySelfAfterDismiss!

attrFoamProgressDialogDontDismissOnCancel
	"@vardata void ATTR_FOAM_PROGRESS_DIALOG_DONT_DISMISS_ON_CANCEL"
	^self addVardata: ##attrFoamProgressDialogDontDismissOnCancel!

!

!FoamProgressDialog methodsFor: 'Geos messages'!

progressDialogSetDescriptionTextOptr: descText
	"@message void MSG_FOAM_PROGRESS_DIALOG_SET_DESCRIPTION_TEXT_OPTR( optr descText = cx:dx)"
	^self geosMessage: #[108 0 2 53 2 0] with: descText!

progressDialogSetStatusText: statusText
	"@message void MSG_FOAM_PROGRESS_DIALOG_SET_STATUS_TEXT( TCHAR *statusText = cx:dx)"
	^self geosMessage: #[108 1 2 53 3 0] with: statusText!

progressDialogSetCancelAction: dest with: msg
	"@message void MSG_FOAM_PROGRESS_DIALOG_SET_CANCEL_ACTION( optr dest = cx:dx, word msg = bp)"
	^self geosMessage: #[108 2 3 245 2 1 0] with: dest with: msg!

progressDialogSetStatusTextOptr: statusText
	"@message void MSG_FOAM_PROGRESS_DIALOG_SET_STATUS_TEXT_OPTR( optr statusText = cx:dx)"
	^self geosMessage: #[108 3 2 53 2 0] with: statusText!

progressDialogAppendStatusText: statusText
	"@message void MSG_FOAM_PROGRESS_DIALOG_APPEND_STATUS_TEXT( TCHAR *statusText = cx:dx)"
	^self geosMessage: #[108 4 2 53 3 0] with: statusText!

progressDialogSetDescriptionText: descText
	"@message void MSG_FOAM_PROGRESS_DIALOG_SET_DESCRIPTION_TEXT( TCHAR *descText = cx:dx)"
	^self geosMessage: #[108 5 2 53 3 0] with: descText!

progressDialogAppendDescriptionText: descText
	"@message void MSG_FOAM_PROGRESS_DIALOG_APPEND_DESCRIPTION_TEXT( TCHAR *descText = cx:dx)"
	^self geosMessage: #[108 6 2 53 3 0] with: descText!

progressDialogCancelTriggered
	"@message void MSG_FOAM_PROGRESS_DIALOG_CANCEL_TRIGGERED()"
	^self geosMessage: #[108 7 2 0 0]!

!

!FoamTextStyleControl comment!
Library foam, file foam.goh! !

!FoamTextStyleControl class methodsFor: 'library linkage'!

library
	^4!

entry
	^115!
!

!FoamTextStyleControl methodsFor: 'Geos instance variables'!

!

!FoamTextStyleControl methodsFor: 'Geos vardata'!

!

!FoamTextStyleControl methodsFor: 'Geos messages'!

plainTextChange
	"@message void MSG_FTSC_PLAIN_TEXT_CHANGE()"
	^self geosMessage: #[108 0 2 0 0]!

styleChange: selectedBooleans with: changedBooleans
	"@message void MSG_FTSC_STYLE_CHANGE(word selectedBooleans = cx, word changedBooleans = bp)"
	^self geosMessage: #[108 1 2 61 1 1 0] with: selectedBooleans with: changedBooleans!

extendedStyleChange: selectedBooleans with: changedBooleans
	"@message void MSG_FTSC_EXTENDED_STYLE_CHANGE(word selectedBooleans = cx, word changedBooleans = bp)"
	^self geosMessage: #[108 2 2 61 1 1 0] with: selectedBooleans with: changedBooleans!

!

!GreyGenInteraction comment!
Library foam, file foam.goh! !

!GreyGenInteraction class methodsFor: 'library linkage'!

library
	^4!

entry
	^94!
!

!GreyGenInteraction methodsFor: 'Geos instance variables'!

!

!GreyGenInteraction methodsFor: 'Geos vardata'!

!

!GreyGenInteraction methodsFor: 'Geos messages'!

!

!IconIndicator comment!
Library foam, file foam.goh! !

!IconIndicator class methodsFor: 'library linkage'!

library
	^4!

entry
	^96!
!

!IconIndicator methodsFor: 'Geos instance variables'!

iiiLeftIconList
	"@instance ChunkHandle III_leftIconList"
	^self wordAt: 19!

iiiLeftIconList: value
	"@instance ChunkHandle III_leftIconList"
	^self wordAt: 19 put: value!

iiiRightIconList
	"@instance ChunkHandle III_rightIconList"
	^self wordAt: 21!

iiiRightIconList: value
	"@instance ChunkHandle III_rightIconList"
	^self wordAt: 21 put: value!

iiiLeftIcon
	"@instance word III_leftIcon"
	^self wordAt: 23!

iiiLeftIcon: value
	"@instance word III_leftIcon"
	^self wordAt: 23 put: value!

iiiRightIcon
	"@instance word III_rightIcon"
	^self wordAt: 25!

iiiRightIcon: value
	"@instance word III_rightIcon"
	^self wordAt: 25 put: value!

!

!IconIndicator methodsFor: 'Geos vardata'!

!

!IconIndicator methodsFor: 'Geos messages'!

setLeftIcon: iconNumber
	"@message void MSG_II_SET_LEFT_ICON(word iconNumber = cx)"
	^self geosMessage: #[108 0 2 5 1 0] with: iconNumber!

setRightIcon: iconNumber
	"@message void MSG_II_SET_RIGHT_ICON(word iconNumber = cx)"
	^self geosMessage: #[108 1 2 5 1 0] with: iconNumber!

!

!LevelIndicator comment!
Library foam, file foam.goh! !

!LevelIndicator class methodsFor: 'library linkage'!

library
	^4!

entry
	^97!
!

!LevelIndicator methodsFor: 'Geos instance variables'!

liiCurrLevel
	"@instance word LII_currLevel"
	^self wordAt: 19!

liiCurrLevel: value
	"@instance word LII_currLevel"
	^self wordAt: 19 put: value!

liiTypeBitmap
	"@instance ChunkHandle LII_typeBitmap"
	^self wordAt: 21!

liiTypeBitmap: value
	"@instance ChunkHandle LII_typeBitmap"
	^self wordAt: 21 put: value!

liiLevelBitmapList
	"@instance ChunkHandle LII_levelBitmapList"
	^self wordAt: 23!

liiLevelBitmapList: value
	"@instance ChunkHandle LII_levelBitmapList"
	^self wordAt: 23 put: value!

!

!LevelIndicator methodsFor: 'Geos vardata'!

hintLiDrawLevelsVertically
	"@vardata void HINT_LI_DRAW_LEVELS_VERTICALLY"
	^self addVardata: ##hintLiDrawLevelsVertically!

!

!LevelIndicator methodsFor: 'Geos messages'!

replaceTypeBitmap: typeBitmap
	"@message void MSG_LI_REPLACE_TYPE_BITMAP(ChunkHandle typeBitmap = cx)"
	^self geosMessage: #[108 0 2 5 1 0] with: typeBitmap!

setLevel: iconNumber
	"@message void MSG_LI_SET_LEVEL(word iconNumber = cx)"
	^self geosMessage: #[108 1 2 5 1 0] with: iconNumber!

!

!UnderlinedTextWithList comment!
Library foam, file foam.goh! !

!UnderlinedTextWithList class methodsFor: 'library linkage'!

library
	^4!

entry
	^99!
!

!UnderlinedTextWithList methodsFor: 'Geos instance variables'!

utwlcListObj
	"@instance optr UTWLC_listObj"
	^self dwordAt: 30!

utwlcListObj: value
	"@instance optr UTWLC_listObj"
	^self dwordAt: 30 put: value!

!

!UnderlinedTextWithList methodsFor: 'Geos vardata'!

attrUnderlinedTextWithListDoNotAllowNavigation
	"@vardata void ATTR_UNDERLINED_TEXT_WITH_LIST_DO_NOT_ALLOW_NAVIGATION"
	^self addVardata: ##attrUnderlinedTextWithListDoNotAllowNavigation!

!

!UnderlinedTextWithList methodsFor: 'Geos messages'!

!

!FoamHelpControl comment!
Library foam, file foam.goh! !

!FoamHelpControl class methodsFor: 'library linkage'!

library
	^4!

entry
	^107!
!

!FoamHelpControl methodsFor: 'Geos instance variables'!

!

!FoamHelpControl methodsFor: 'Geos vardata'!

tempFoamHelpControlUi: value
	"@vardata hptr TEMP_FOAM_HELP_CONTROL_UI"
	^self addVardata: ##tempFoamHelpControlUi word: value!

!

!FoamHelpControl methodsFor: 'Geos messages'!

!

